SWEP.AdminSpawnable = true
SWEP.ViewModelFOV = 90
SWEP.ViewModel = "models/weapons/v_HMGcool.mdl"
SWEP.WorldModel = "models/w_hmgc.mdl"
SWEP.AutoSwitchTo = true
SWEP.Slot = 3
SWEP.HoldType = "crossbow"
SWEP.PrintName = "H.M.G. Cooling Mod"
SWEP.Author = "Nightstalker"
SWEP.Spawnable = true
SWEP.AutoSwitchFrom = true
SWEP.FiresUnderwater = true
SWEP.Weight = 5
SWEP.DrawCrosshair = false
SWEP.Category = "Kingpin"
SWEP.SlotPos = 2
SWEP.DrawAmmo = true
SWEP.Base = "kingpin_base"
if CLIENT then
	SWEP.WepSelectIcon = surface.GetTextureID("vgui/h_heavymachinegun_cooling")
	killicon.Add("kingpin_hmgcool", "vgui/ah_heavymachinegun_cooling", Color(255, 80, 0, 255))
end
SWEP.Primary.Sound = Sound("v_hmgk/hmg.wav")
SWEP.Primary.Reload = Sound("v_hmgk/hmgcock.wav")
SWEP.Primary.Damage = 35
SWEP.Primary.TakeAmmo = 1
SWEP.Primary.ClipSize = 30
SWEP.Primary.Ammo = "ar2"
SWEP.Primary.DefaultClip = 30
SWEP.Primary.Cone = 0
SWEP.Primary.NumberofShots = 1
SWEP.Primary.Automatic = true
SWEP.Primary.Recoil = 1
SWEP.Primary.Delay = 0.7
SWEP.Primary.Force = 6
SWEP.BobScale	= 0.3
SWEP.SwayScale	= 0.1

function SWEP:Deploy()
	self.Weapon:SetNextPrimaryFire(CurTime() + 0.5)
	self.Weapon:SendWeaponAnim(ACT_VM_DRAW)
	return true
end

function SWEP:Initialize()
	self:SetWeaponHoldType(self.HoldType)
end

function SWEP:Holster()
	return self:GetNextPrimaryFire() < CurTime()
end

function SWEP:kMuzzleFlash()
	local pos = self.Owner:GetShootPos()
	local ang = self.Owner:GetAimVector():Angle()
	pos = pos +ang:Forward() *50 +ang:Right() *14 +ang:Up() *-9
	local effectdata = EffectData()
	effectdata:SetStart(pos)
	effectdata:SetOrigin(pos)
	util.Effect("kp_hmgmuzz", effectdata)
end



function SWEP:PrimaryAttack()
	if !self:CanPrimaryAttack() then return end
	self:ShootBullet(self.Primary.Damage, self.Primary.Recoil, self.Primary.NumShots, self.Primary.Cone)
if SERVER then		self.Owner:EmitSound(self.Primary.Sound)  end
	for i = 0.1, 0.2, 0.1 do
		timer.Simple(i, function()
			self:ShootBullet(self.Primary.Damage, self.Primary.Recoil, self.Primary.NumShots, self.Primary.Cone)
		end)
	end
	self.Weapon:SetNextPrimaryFire(CurTime() + self.Primary.Delay)
end



function SWEP:DryFire()
	self.Weapon:EmitSound("weapons/v_pipebar/noammo.wav")
end

function SWEP:Reload()
	if (self.Weapon:Ammo1() <= 0) then return end
	if (self.Weapon:Clip1() >= self.Primary.ClipSize) then return end
	self.Weapon:DefaultReload(ACT_VM_RELOAD)
	self:EmitSound("v_hmgk/hmgcock.wav")
	self.Weapon:SetNextPrimaryFire(CurTime() + 0.5)
end

function SWEP:ShootBullet(dmg, recoil, numbul, cone, ric)
	if not IsValid(self.Owner) or self.Owner:Health() < 0 or !self:CanPrimaryAttack() then return end
	numbul 	= numbul 	or 1
	cone 	= cone 		or 0.0
	self.Owner:FireBullets({
		Num 	= numbul,
		Src 	= self.Owner:GetShootPos(),
		Dir 	= self.Owner:GetAimVector(),
		Spread 	= Vector(cone, cone, 0),
		Tracer	= 4,
		Force	= 6,
		Damage	= dmg,
	})
self.Weapon:SendWeaponAnim(ACT_VM_IDLE)
timer.Simple(FrameTime() * 2, function() self.Weapon:SendWeaponAnim(ACT_VM_PRIMARYATTACK) end)

	self.Owner:SetAnimation(PLAYER_ATTACK1)
	self:kMuzzleFlash()
	self.Owner:ViewPunch(Angle(self.Primary.Recoil * -1, self.Primary.Recoil * math.Rand(-1, 1), self.Primary.Recoil * -1))
	self:TakePrimaryAmmo(self.Primary.TakeAmmo)
end